<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class ScreenSub extends Model
{

    protected $primaryKey = 'screen_sub_id';

    public static $main_table = 'screen_subs';

    public static $rules = array(
        'screen_sub_title_en'   => 'required|string|min:3',
        'screen_sub_title_ar'   => 'required|string|min:3',
        'screen_cat_id'         => 'required|numeric' , 
        'screen_code'           => 'required',
        'actions'               => 'required',
        'url'                   => 'required'
    );


    public static function all_screen_subs($params = null )
    {
        $query =  DB::table(self::$main_table)
            ->join('screen_cats' , self::$main_table.'.screen_cat_id' , '=' , 'screen_cats.screen_cat_id')
            ->join('screen_mains' , 'screen_cats.screen_main_id' , '=' , 'screen_mains.screen_main_id')
            ->orderBy(self::$main_table.'.screen_cat_id')
            ->orderBy('screen_sub_order');

        if(isset($params['lang'])){
            $query->selectRaw(
                self::$main_table.'.screen_sub_id as sub_id ,  
                screen_sub_title_'.$params['lang'].' as sub_title ,
                screen_cats.screen_cat_id as cat_id , 
                screen_cat_title_'.$params['lang'].' as cat_title ,
                screen_mains.screen_main_id as main_id , 
                screen_main_title_'.$params['lang'].' as main_title ,
                screen_main_image as main_image ,
                screen_code ,
                actions , 
                url
            ');
        }


        if(isset($params['main']))
            $query->where('screen_cats.screen_main_id' , $params['main'] );

        if(isset($params['cat']))
            $query->where( self::$main_table.'.screen_cat_id' , $params['cat'] );


        if(isset($params['screen']))
            $query->where('screen'  , $params['screen']);

        if(isset($params['active']))
            $query->where('screen_sub_active' , $params['active'] );
        

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('screen_main_title_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('screen_main_title_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('screen_cat_title_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('screen_cat_title_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('screen_sub_title_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('screen_sub_title_ar' , 'LIKE' , "%{$params['word']}%");
            });
            
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }
        
        return $data;
    }

    public static function get_screen_sub($id , $lang = null)
    {
       $query =  DB::table(self::$main_table)
            ->where('screen_sub_id' , $id) 
            ->join('screen_cats' , self::$main_table.'.screen_cat_id' , '=' , 'screen_cats.screen_cat_id')
            ->join('screen_mains' , 'screen_cats.screen_main_id' , '=' , 'screen_mains.screen_main_id');

        if($lang != null){
            $query->selectRaw(
                self::$main_table.'.screen_sub_id as sub_id ,  
                screen_sub_title_'.$lang.' as sub_title ,
                screen_cats.screen_cat_id as cat_id , 
                screen_cat_title_'.$lang.' as cat_title ,
                screen_mains.screen_main_id as main_id , 
                screen_main_title_'.$lang.' as screen_main ,
                screen_code ,
                actions , 
                url
            ');
        }
        
        $data = $query->first();
    return $data;
    }



    public static function get_screen_sub_by_screen_code($id , $lang = null)
    {
       $query =  DB::table(self::$main_table)
            ->where('screen_code' , $id) 
            ->join('screen_cats' , self::$main_table.'.screen_cat_id' , '=' , 'screen_cats.screen_cat_id')
            ->join('screen_mains' , 'screen_cats.screen_main_id' , '=' , 'screen_mains.screen_main_id');

        if($lang != null){
            $query->selectRaw(
                self::$main_table.'.screen_sub_id as sub_id ,  
                screen_sub_title_'.$lang.' as sub_title ,
                screen_cats.screen_cat_id as cat_id , 
                screen_cat_title_'.$lang.' as cat_title ,
                screen_mains.screen_main_id as main_id , 
                screen_main_title_'.$lang.' as screen_main ,
                screen_sub_title_ar ,
                screen_sub_title_en ,
                screen_code ,
                actions , 
                url
            ');
        }
        
        $data = $query->first();
    return $data;
    }



    public static function add_screen_sub($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_screen_sub($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('screen_sub_id' , $id )->update($seed);
    }

    public static function delete_screen_sub($id)
    {
        return DB::table(self::$main_table)->where('screen_sub_id' , $id )->update(array('screen_sub_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") ,  'disable_user' => auth()->user()->id ));
    }
}
