<?php

namespace App\Models\POS;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Coupons extends Model
{
    protected $primaryKey = 'coupon_id';

    public static $main_table = 'coupons';

    public static $rules = array(
        'coupon_code'       => 'required|string|unique:coupons',
        'end_date'          => 'required|date',
    );

    public static function all_coupons($params = null)
    {
        $query = DB::table(self::$main_table)
        ->leftjoin('platforms', function ($join) {
            $join->on(DB::raw('FIND_IN_SET(platforms.platform_id,coupons.platforms_id)'),'>', DB::raw("'0'"));
        })
         ->leftjoin('sales_invoice_m','sales_invoice_m.coupon_id' , 'coupons.coupon_id')
        ->groupBy('coupons.coupon_id')
        ->orderBy(self::$main_table.'.coupon_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                coupons.coupon_id as id,
                coupons.coupon_code ,
                coupons.coupon_type ,
                coupons.start_date ,
                coupons.end_date ,
                coupons.platforms_id ,
                GROUP_CONCAT(distinct platforms.name_'.$params['lang'].') as platforms_name ,
                COUNT(sales_invoice_m.coupon_id) as used_count,
                coupons.services ,
                coupons.customers_id ,
                coupons.for_customer ,
                coupons.allowed_count ,
                coupons.active ,
                coupons.discount ,
                coupons.add_user ,
                coupons.add_date
            ');
        }

        if(isset($params['active'])){
            $query->where('active', $params['active']);
        }

        if(isset($params['from'])){
            $query->where(self::$main_table.'.start_date', '>=', $params['from_date']);
        }

        if(isset($params['to'])){
            $query->where(self::$main_table.'.end_date', '<=', $params['to_date']);
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_coupon($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin("platforms",DB::raw("FIND_IN_SET(platforms.platform_id,coupons.platforms_id)"),">",DB::raw("'0'"))
            ->leftJoin('sales_invoice_m','sales_invoice_m.coupon_id' ,'coupons.coupon_id')
            ->where('coupons.coupon_id', $id);

        if($lang != null){
            $query->selectRaw('
                coupons.coupon_id as id,
                coupons.coupon_code ,
                coupons.coupon_type ,
                coupons.start_date ,
                coupons.end_date ,
                coupons.platforms_id ,
                GROUP_CONCAT(distinct platforms.name_'.$lang.') as platforms_name ,
                COUNT(sales_invoice_m.coupon_id) as used_count,
                coupons.services ,
                coupons.customers_id ,
                coupons.for_customer ,
                coupons.allowed_count ,
                coupons.active ,
                coupons.discount ,
                coupons.add_user ,
                coupons.add_date
            ');
        }

        $data = $query->first();
        return $data;
    }
    public static function all_codes($id = null){
        $query = DB::table(self::$main_table);
        if(isset($id) && $id > 0){
            $query->where('coupon_id','!=', $id);
        }
        $data = $query->pluck('coupon_code')->toArray();

        return $data;
    }


    public static function add_coupon($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_coupon($seed, $id)
    {
        return DB::table(self::$main_table)->where('coupon_id', $id)->update($seed);
    }

    public static function hard_delete_coupon($id)
    {
        return DB::table(self::$main_table)->where('coupon_id', $id)->delete();
    }

    public static function delete_coupon($id)
    {
        return DB::table(self::$main_table)->where('coupon_id', $id)->update(array('active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }


}
