<?php

namespace App\Models\POS;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class SalesInvoice extends Model
{
    protected $primaryKey = 'sales_invoice_m_id';

    public static $main_table = 'sales_invoice_m';

    public static $details_rules = array(
        'item_id'        => 'required|numeric',
        'warehouse_id'   => 'required|numeric',
        'unit_id'        => 'required|numeric',
        'quantity'       => 'required|numeric',
        'price'          => 'required',
        'tax_percent_id' => 'required|numeric',
    );


    public static function all_sales_invoices($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('sales_invoice_payments', self::$main_table.'.sales_invoice_m_id', '=', 'sales_invoice_payments.sales_invoice_m_id')
            ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type', '=', 'payment_methods.payment_method_id')
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->leftjoin('sales_agents', self::$main_table.'.sales_agent_id', '=', 'sales_agents.sales_agent_id')
            ->leftjoin('sales_invoice_types', self::$main_table.'.sales_invoice_type_id', '=', 'sales_invoice_types.sales_invoice_type_id')
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->leftjoin('barber_m', self::$main_table.'.barber_id', '=', 'barber_m.barber_m_id')
            ->leftjoin('coupons', self::$main_table.'.coupon_id', '=', 'coupons.coupon_id')
            ->orderBy(self::$main_table.'.sales_invoice_m_id', 'desc')
            ->groupBy(self::$main_table.'.sales_invoice_m_id');

        if($params['lang'] != null){
            $query->selectRaw(
                self::$main_table.'.sales_invoice_m_id as m_id ,
                GROUP_CONCAT(distinct payment_methods.name_'.$params['lang'].' SEPARATOR ",") as payment_type_title ,
                sales_invoice_date ,
                sales_invoice_description ,'.
                self::$main_table.'.sales_invoice_type_id ,
                sales_invoice_types.sales_invoice_type_title_'.$params['lang'].' as type_title ,
                link_cost_center ,
                if(link_cost_center = "1", true, false ) as has_cost_center ,
                sales_invoice_m.cost_center_id ,'.
                self::$main_table.'.proforma_invoice_id ,'.
                self::$main_table.'.barber_id ,
                barber_m.name_'.$params['lang'].' as barber_name ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$params['lang'].' as customer_name ,'.
                self::$main_table.'.coupon_id ,
                coupons.coupon_code as coupon_code ,
                customer_invoice_type ,
                customers.address ,
                customers.phone as customer_phone ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$params['lang'].' as sales_agent_name ,
                supply_order ,
                sales_invoice_m.branch_id ,
                finance_year_id ,
                if(invoice_discount = "1", true, false ) as has_discount ,
                discount_type ,
                sales_invoice_m.discount ,
                items_count ,
                sales_invoice_status ,
                sales_invoice_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                users.user_full_name ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                total_discount ,
                total_without_vat_after_discount ,
                total_price_after_discount
            ');
        }

        if(isset($params['active'])){
            $query->where('sales_invoice_active', $params['active']);
        }

        if(isset($params['from_date'])){
            $query->where(self::$main_table.'.sales_invoice_date', '>=', $params['from_date'].' 00:00:00');
        }

        if(isset($params['to_date'])){
            $query->where(self::$main_table.'.sales_invoice_date', '<=', $params['to_date'].' 23:59:59');
        }

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.sales_invoice_m_id', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.phone', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_sales_invoice_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('sales_invoice_payments', self::$main_table.'.sales_invoice_m_id', '=', 'sales_invoice_payments.sales_invoice_m_id')
            ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type', '=', 'payment_methods.payment_method_id')
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->leftjoin('sales_agents', self::$main_table.'.sales_agent_id', '=', 'sales_agents.sales_agent_id')
            ->leftjoin('sales_invoice_types', self::$main_table.'.sales_invoice_type_id', '=', 'sales_invoice_types.sales_invoice_type_id')
            ->leftjoin('barber_m', self::$main_table.'.barber_id', '=', 'barber_m.barber_m_id')
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->leftjoin('branchs', self::$main_table.'.branch_id', '=', 'branchs.branch_id')
            ->leftjoin('coupons', self::$main_table.'.coupon_id', '=', 'coupons.coupon_id')
            ->where(self::$main_table.'.sales_invoice_m_id', $id);

        if($lang != null){
            $query->selectRaw(
                self::$main_table.'.sales_invoice_m_id as m_id ,
                GROUP_CONCAT(distinct payment_methods.name_'.$lang.' SEPARATOR ",") as payment_type_title ,
                branchs.treasury_account_id as branch_treasury_account_id ,
                sales_invoice_date ,
                sales_invoice_description ,'.
                self::$main_table.'.sales_invoice_type_id ,
                sales_invoice_types.sales_invoice_type_title_'.$lang.' as type_title ,
                link_cost_center ,
                if(link_cost_center = "1", true, false ) as has_cost_center ,
                sales_invoice_m.cost_center_id ,'.
                self::$main_table.'.proforma_invoice_id ,'.
                self::$main_table.'.customer_id ,'.
                self::$main_table.'.coupon_id ,
                coupons.coupon_code as coupon_code ,
                customers.name_'.$lang.' as customer_name ,'.
                self::$main_table.'.barber_id ,
                barber_m.name_'.$lang.' as barber_name ,
                customer_invoice_type ,
                customers.commercial_registeration_no ,
                customers.vat_register_number ,
                customers.address ,
                customers.phone as customer_phone ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$lang.' as sales_agent_name ,
                supply_order ,
                sales_invoice_m.branch_id ,
                finance_year_id ,
                if(invoice_discount = "1", true, false ) as has_discount ,
                discount_type ,
                sales_invoice_m.discount ,
                items_count ,
                sales_invoice_status ,
                sales_invoice_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                users.user_full_name ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                total_discount ,
                total_without_vat_after_discount ,
                total_price_after_discount
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_sales_invoice_d($id, $lang = null, $detail_type = null)
    {
        $query = DB::table('sales_invoice_d')
            ->leftjoin('items', 'sales_invoice_d.item_id', '=', 'items.item_id')
            ->leftjoin('categorys' , 'items.category_id' , '=' , 'categorys.category_id')
            ->leftjoin('warehouses', 'sales_invoice_d.warehouse_id', '=', 'warehouses.warehouse_id')
            ->leftjoin('unit_measurements', 'sales_invoice_d.unit_id', '=', 'unit_measurements.unit_measurement_id')
            ->leftjoin('taxes', 'sales_invoice_d.tax_percent_id', '=', 'taxes.tax_id')
            ->where('sales_invoice_m_id', $id);

        if($detail_type != null){
            $query->where('sales_invoice_d.detail_type', $detail_type);
        }

        if($lang != null){
            $query->selectRaw('
                sales_invoice_m_id as m_id ,
                sales_invoice_d_id as d_id ,
                sales_invoice_d.item_id ,
                items.name_'.$lang.' as item_name ,
                items.image as item_image ,
                items.category_id ,
                categorys.name_'.$lang.' as category_name ,
                items.price_include_vat ,
                sales_invoice_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                sales_invoice_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                quantity ,
                sales_invoice_d.description ,
                
                item_number ,

                sales_invoice_d.price ,
                sales_invoice_d.item_price ,
                sales_invoice_d.total_price ,
                sales_invoice_d.item_discount ,
                sales_invoice_d.total_discount ,


                discount ,
                discount_per ,
                total_price_after_discount ,
                item_price_after_discount ,
                current_quantity ,
                current_price ,
                current_total_price ,
                current_total_price_after_discount ,
                tax_percent_id ,
                taxes.tax_percentage as tax_percent ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                current_total_vat ,
                current_total_without_vat ,
                current_total_with_vat ,
                detail_type
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function get_next($id, $branch)
    {
        return DB::table(self::$main_table)
            ->where('sales_invoice_m_id', '>', $id)
            ->where('sales_invoice_active', 1)
            ->where(self::$main_table.'.branch_id', $branch)
            ->selectRaw('sales_invoice_m_id as m_id')
            ->first();
    }

    public static function get_previous($id, $branch)
    {
        return DB::table(self::$main_table)
            ->where('sales_invoice_m_id', '<', $id)
            ->where('sales_invoice_active', 1)
            ->where(self::$main_table.'.branch_id', $branch)
            ->selectRaw('sales_invoice_m_id as m_id')
            ->first();
    }

    public static function get_last($branch)
    {
        return DB::table(self::$main_table)
            ->where('sales_invoice_active', 1)
            ->where(self::$main_table.'.branch_id', $branch)
            ->selectRaw('sales_invoice_m_id as m_id')
            ->orderBy('sales_invoice_m_id', 'desc')
            ->first();
    }

    public static function get_payments($id, $lang)
    {
        return DB::table('sales_invoice_payments')
            ->leftjoin('network_machines', 'sales_invoice_payments.machine_id', '=', 'network_machines.network_machine_id')
            ->leftjoin('treasurys', 'sales_invoice_payments.treasury_id', '=', 'treasurys.treasury_id')
            ->where('sales_invoice_m_id', $id)
            ->selectRaw('* , network_machines.name_'.$lang.' as machine_name , treasurys.treasury_name_'.$lang.' as treasury_name , treasurys.account_tree_id as treasury_account_tree_id , network_machines.account_tree_id as machine_account_tree_id')
            ->get();
    }

    public static function daily_requests($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->where(self::$main_table.'.sales_invoice_date', date('Y-m-d'))
            ->where(self::$main_table.'.add_user', auth()->user()->id)
            ->orderBy(self::$main_table.'.sales_invoice_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                sales_invoice_m_id as m_id ,
                sales_invoice_date ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$params['lang'].' as customer_name ,
                items_count ,
                total_with_vat ,
                total_with_vat_after_discount
            ');
        }

        if(isset($params['active']))
            $query->where(self::$main_table.'.sales_invoice_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.sales_invoice_m_id', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_en', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function add_sales_invoice_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_sales_invoice_d($seed)
    {
        return DB::table('sales_invoice_d')->insertGetId($seed);
    }

    public static function update_sales_invoice_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('sales_invoice_m_id', $id)->update($seed);
    }

    public static function update_sales_invoice_d($seed, $id)
    {
        return DB::table('sales_invoice_d')->where('sales_invoice_d_id', $id)->update($seed);
    }

    public static function delete_sales_invoice_m($id)
    {
        return DB::table(self::$main_table)->where('sales_invoice_m_id', $id)->update(array('sales_invoice_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_sales_invoice_d($id)
    {
        return DB::table('sales_invoice_d')->where('sales_invoice_d_id', $id)->delete();
    }
}
