<?php

namespace App\Models\Purchases;

use Illuminate\Database\Eloquent\Model;
use DB;

class PurchasesInvoice extends Model
{
    protected $primaryKey     = 'purchases_invoice_m_id';
    public static $main_table = 'purchases_invoice_m';
    public $table             = 'purchases_invoice_m';

    public static $master_rules = array(
        'purchases_invoice_type_id'     => 'required|numeric',
        'purchases_invoice_date'        => 'required|date',
        'purchases_invoice_detail'      => 'required|numeric',
        'purchases_vendor_id'           => 'required|numeric',
        'purchases_agent_id'            => 'required|numeric',
        'purchases_vendor_invoice_no'   => 'required|numeric',
        'purchases_order_id'            => 'required|numeric',
        'currency_id'                   => 'required|numeric',
//        'purchases_invoice_description' => 'required',
    );

    public static $details_rules = array(
        'warehouse_id'   => 'required|numeric',
        'item_id'        => 'required|numeric',
        'unit_id'        => 'required|numeric',
        'quantity'       => 'required|numeric',
        'price'          => 'required',
        'tax_percent_id' => 'required|numeric',
    );

    public static function all_purchases_invoices($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('purchases_vendors' , self::$main_table.'.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
            ->leftjoin('purchases_agents' , self::$main_table.'.purchases_agent_id' , '=' , 'purchases_agents.purchases_agent_id')
            ->leftjoin('purchases_invoice_types' , self::$main_table.'.purchases_invoice_type_id' , '=' , 'purchases_invoice_types.purchases_invoice_type_id')
            ->orderBy(self::$main_table.'.purchases_invoice_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                purchases_invoice_m_id as m_id ,'.
                self::$main_table.'.purchases_invoice_type_id ,
                purchases_invoice_types.purchases_invoice_type_title_'.$params['lang'].' as purchases_invoice_type_name ,
                purchases_invoice_date ,
                purchases_invoice_detail ,'.
                self::$main_table.'.purchases_vendor_id ,
                purchases_vendors.name_'.$params['lang'].' as purchases_vendor_name ,'.
                self::$main_table.'.purchases_agent_id ,
                purchases_agents.name_'.$params['lang'].' as purchases_agent_name ,
                purchases_vendor_invoice_no ,
                branch_id ,
                finance_year_id ,'.
                self::$main_table.'.currency_id ,
                purchases_invoice_description ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                invoice_discount,
                discount_type,
                discount,

                current_total_vat ,
                current_total_without_vat ,
                current_total_with_vat ,
                purchases_invoice_status ,
                purchases_invoice_active as active ,
                purchases_invoice_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        if(isset($params['active']))
            $query->where('purchases_invoice_active', $params['active']);

        if(isset($params['status']))
            $query->where('purchases_invoice_status', $params['status']);

        if(isset($params['type']))
            $query->where('purchases_invoice_m.purchases_invoice_type_id', $params['type']);

        if(isset($params['date']))
            $query->where('purchases_invoice_date', $params['date']);

        if(isset($params['customer']))
            $query->where('customer_id', $params['customer']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('purchases_invoice_description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('purchases_vendors.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('purchases_vendors.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('purchases_agents.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('purchases_agents.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('purchases_invoice_m_id', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_purchases_invoice_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('purchases_vendors' , self::$main_table.'.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
            ->leftjoin('purchases_agents' , self::$main_table.'.purchases_agent_id' , '=' , 'purchases_agents.purchases_agent_id')
            ->leftjoin('purchases_invoice_types' , self::$main_table.'.purchases_invoice_type_id' , '=' , 'purchases_invoice_types.purchases_invoice_type_id')
            ->where('purchases_invoice_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                purchases_invoice_m_id as m_id ,'.
                self::$main_table.'.purchases_invoice_type_id ,
                purchases_invoice_m.daily_journal_m_id ,
                purchases_invoice_types.purchases_invoice_type_title_'.$lang.' as purchases_invoice_type_name ,
                purchases_invoice_date ,
                purchases_invoice_m.extra_inputs,
                purchases_invoice_detail ,'.
                self::$main_table.'.purchases_vendor_id ,
                purchases_vendors.name_'.$lang.' as purchases_vendor_name ,
                purchases_vendors.account_tree_id as purchase_vendor_account_tree_id , '.
                self::$main_table.'.purchases_agent_id ,
                purchases_agents.name_'.$lang.' as purchases_agent_name ,
                purchases_vendor_invoice_no ,
                branch_id ,
                finance_year_id ,'.
                self::$main_table.'.currency_id ,
                purchases_invoice_description ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                invoice_discount,
                discount_type,
                discount,
                current_total_vat ,
                current_total_without_vat ,
                current_total_with_vat ,
                purchases_invoice_status ,
                purchases_invoice_active as active ,
                purchases_invoice_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_purchases_invoice_d($id, $lang = null)
    {
        $query = DB::table('purchases_invoice_d')
            ->leftjoin('warehouses' , 'purchases_invoice_d.warehouse_id' , '=' , 'warehouses.warehouse_id')
            ->leftjoin('items' , 'purchases_invoice_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('unit_measurements' , 'purchases_invoice_d.unit_id' , '=' , 'unit_measurements.unit_measurement_id')
            ->leftjoin('taxes' , 'purchases_invoice_d.tax_percent_id' , '=' , 'taxes.tax_id')
            ->where('purchases_invoice_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                purchases_invoice_m_id as m_id ,
                purchases_invoice_d_id as d_id ,
                purchases_invoice_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                purchases_invoice_d.item_id ,
                items.name_'.$lang.' as item_name ,
                items.location,
                purchases_invoice_d.extra_inputs,
                items.price_include_vat,
                purchases_invoice_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                quantity ,
                price ,
                total_price ,
                purchases_invoice_d.currency_id ,
                purchases_invoice_d.foreign_currency ,
                purchases_invoice_d.equivalent_value ,

                (total_without_vat / quantity) + (total_discount / quantity) as price_without_vat,
                total_discount ,
                tax_percent_id ,
                taxes.name_'.$lang.' as tax_percent ,
                taxes.tax_percentage ,
                taxes.account_tree_id as tax_account_tree_id ,
                items.purchases_revenue_id ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                current_price ,
                current_total_price ,
                current_total_vat ,
                current_total_without_vat ,
                current_total_with_vat ,
                current_quantity,
                discount_per
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function get_purchases_invoice_files($id)
    {
        return DB::table('purchases_invoice_attachments')
            ->where('purchase_invoice_id', $id)
            ->selectRaw('
                attachment_id as id ,
                purchase_invoice_id ,
                file_name ,
                file_path ,
                file_ext ,
                add_date ,
                add_user
            ')
            ->get();
    }

    public static function add_purchases_invoice_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_purchases_invoice_d($seed)
    {
        return DB::table('purchases_invoice_d')->insertGetId($seed);
    }

    public static function update_purchases_invoice_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('purchases_invoice_m_id', $id)->update($seed);
    }

    public static function update_purchases_invoice_d($seed, $id)
    {
        return DB::table('purchases_invoice_d')->where('purchases_invoice_d_id', $id)->update($seed);
    }

    public static function delete_purchases_invoice_m($id)
    {
        // return DB::table(self::$main_table)->where('purchases_invoice_m_id', $id)->update(array('purchases_invoice_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
        return DB::table(self::$main_table)->where('purchases_invoice_m_id', $id)->delete();
    }

    public static function delete_purchases_invoice_d($id)
    {
        return DB::table('purchases_invoice_d')->where('purchases_invoice_d_id', $id)->delete();
    }
}
