<?php

use Illuminate\Support\Facades\Route;


Route::group(['prefix' => 'v1/{lang}', 'where' => ['lang' => 'en|ar'], "namespace" => "App\Http\Controllers\API\V1"], function () {

    Route::post('/login', "AuthController@login");
    Route::post('/elevators_client_response/{id}', "Elevators\ElevatorsQuotationController@client_response");
    Route::get('/elevators_quotation_link/{encryptedParameter}', "Elevators\ElevatorsQuotationController@show_link");

    Route::group(['middleware' => 'auth:api'], function () {
        Route::post('/logout', "AuthController@logout");
        // Route::get('/update_v2', "GeneralController@update_v2");

        Route::get('/get_my_profile', "GeneralController@get_my_profile");
        Route::get('/get_lookups', "Main\LookupsController@index");
        Route::post('/show_lookups', "Main\LookupsController@show");

        Route::get('/get_erp_data', "GeneralController@get_home_data");
        Route::get('/get_profile_data', "GeneralController@get_profile_data");

        Route::get('/send_notification', "GeneralController@send_notification");
        Route::post('/update_profile', "GeneralController@update_profile");
        Route::post('/change_password', "Main\UserController@change_password");
        Route::post('/change_user_defaults', "Main\UserController@change_user_defaults");

        Route::resource('/setting', "Main\SettingController");

        Route::resource('/user', "Main\UserController");
        Route::post('/update_permission/{id}', "Main\UserController@update_permission");
        Route::post('/user_toggle_active/{id}', "Main\UserController@toggle_active");

        Route::resource('/branch', "Main\BranchController");
        Route::post('/branch_sort', "Main\BranchController@sort_post");
        Route::post('/branch_toggle_active/{id}', "Main\BranchController@toggle_active");

        Route::resource('/bank', "Main\BankController");
        Route::post('/bank_sort', "Main\BankController@sort_post");
        Route::post('/bank_toggle_active/{id}', "Main\BankController@toggle_active");

        Route::resource('/location', "Main\LocationController");


        Route::resource('/network_machine', "Main\NetworkMachineController");

        Route::post('/network_machine_sort', "Main\NetworkMachineController@sort_post");
        Route::post('/network_machine_toggle_active/{id}', "Main\NetworkMachineController@toggle_active");

        Route::resource('/finance_year', "Main\FinanceYearController");
        Route::post('/finance_year_sort', "Main\FinanceYearController@sort_post");
        Route::post('/finance_year_toggle_active/{id}', "Main\FinanceYearController@toggle_active");


        Route::resource('/daily_type', "Main\DailyTypeController");
        Route::post('/daily_type_sort', "Main\DailyTypeController@sort_post");
        Route::post('/daily_type_toggle_active/{id}', "Main\DailyTypeController@toggle_active");

        Route::resource('/partner', "Main\PartnerController");
        Route::post('/partner_sort', "Main\PartnerController@sort_post");
        Route::post('/partner_toggle_active/{id}', "Main\PartnerController@toggle_active");

        Route::resource('/screen_main', "Main\ScreenMainController");
        Route::post('/screen_main_sort', "Main\ScreenMainController@sort_post");
        Route::post('/screen_main_toggle_active/{id}', "Main\ScreenMainController@toggle_active");

        Route::resource('/screen_cat', "Main\ScreenCatController");
        Route::post('/screen_cat_sort', "Main\ScreenCatController@sort_post");
        Route::post('/screen_cat_toggle_active/{id}', "Main\ScreenCatController@toggle_active");

        Route::resource('/screen_sub', "Main\ScreenSubController");
        Route::post('/screen_sub_sort', "Main\ScreenSubController@sort_post");
        Route::post('/screen_sub_toggle_active/{id}', "Main\ScreenSubController@toggle_active");

        Route::resource('/sales_agent', "Main\SalesAgentController");
        Route::post('/sales_agent_sort', "Main\SalesAgentController@sort_post");
        Route::post('/sales_agent_toggle_active/{id}', "Main\SalesAgentController@toggle_active");

        Route::resource('/delegate', "Main\DelegateController");
        Route::post('/delegate_sort', "Main\DelegateController@sort_post");
        Route::post('/delegate_toggle_active/{id}', "Main\DelegateController@toggle_active");

        Route::resource('/title', "Main\TitleController");
        Route::post('/title_toggle_active/{id}', "Main\TitleController@toggle_active");

        // Finance

        Route::resource('/account_tree', "Finance\AccountTreeController");
        Route::post('/account_tree_toggle_active/{id}', "Finance\AccountTreeController@toggle_active");

        Route::resource('/cost_center', "Finance\CostCenterController");
        Route::post('/cost_center_toggle_active/{id}', "Finance\CostCenterController@toggle_active");

        Route::resource('/daily_journal', "Finance\DailyJournalController");
        Route::post('/daily_journal_toggle_active/{id}', "Finance\DailyJournalController@toggle_active");
        Route::post('/export_journal_data/{id}', "Finance\DailyJournalController@export_journal_data");
        Route::post('/add_daily_journal_attach/{id}', "Finance\DailyJournalController@add_daily_journal_attach");
        Route::get('/get_daily_journal_attach/{id}', "Finance\DailyJournalController@get_daily_journal_attach");
        Route::post('/add_daily_journal_master_attach/{id}', "Finance\DailyJournalController@add_master_attach");
        Route::get('/download_daily_journal_master_attach/{id}', "Finance\DailyJournalController@download_master_attach");
        Route::post('/delete_daily_journal_master_attachment/{id}', "Finance\DailyJournalController@delete_master_attach");

        Route::resource('/currency', "Finance\CurrencyController");
        Route::post('/currency_toggle_active/{id}', "Finance\CurrencyController@toggle_active");

        Route::resource('/treasury', "Finance\TreasuryController");
        Route::post('/treasury_sort', "Finance\TreasuryController@sort_post");
        Route::post('/treasury_toggle_active/{id}', "Finance\TreasuryController@toggle_active");

        Route::resource('/financial_period', "Finance\FinancialPeriodController");
        Route::post('/financial_period_toggle_active/{id}', "Finance\FinancialPeriodController@toggle_active");
        Route::post('/close_finance_year/{id}', "Finance\FinancialPeriodController@close_finance_year");


        Route::resource('/receipt_voucher', "Finance\ReceiptVoucherController");
        Route::post('/receipt_voucher_toggle_active/{id}', "Finance\ReceiptVoucherController@toggle_active");
        Route::post('/export_receipt_voucher/{id}', "Finance\ReceiptVoucherController@export_data");
        Route::post('/add_receipt_voucher_attach/{id}', "Finance\ReceiptVoucherController@add_attach");
        Route::get('/get_receipt_voucher_attachs/{id}', "Finance\ReceiptVoucherController@get_attachs");
        Route::get('/download_receipt_voucher_attach/{id}', "Finance\ReceiptVoucherController@download_attach");
        Route::delete('/delete_receipt_voucher_attachment/{id}', "Finance\ReceiptVoucherController@delete_attach");


        Route::resource('/payment_voucher', "Finance\PaymentVoucherController");
        Route::post('/payment_voucher_toggle_active/{id}', "Finance\PaymentVoucherController@toggle_active");
        Route::post('/export_payment_voucher/{id}', "Finance\PaymentVoucherController@export_data");
        Route::post('/add_payment_voucher_attach/{id}', "Finance\PaymentVoucherController@add_attach");
        Route::get('/get_payment_voucher_attachs/{id}', "Finance\PaymentVoucherController@get_attachs");
        Route::get('/download_payment_voucher_attach/{id}', "Finance\PaymentVoucherController@download_attach");
        Route::delete('/delete_payment_voucher_attachment/{id}', "Finance\PaymentVoucherController@delete_attach");

        Route::resource('/multi_voucher', "Finance\MultiVoucherController");
        Route::post('/multi_voucher_toggle_active/{id}', "Finance\MultiVoucherController@toggle_active");
        Route::post('/export_multi_voucher/{id}', "Finance\MultiVoucherController@export_data");
        Route::post('/add_multi_voucher_attach/{id}', "Finance\MultiVoucherController@add_attach");
        Route::get('/get_multi_voucher_attachs/{id}', "Finance\MultiVoucherController@get_attachs");
        Route::get('/download_multi_voucher_attach/{id}', "Finance\MultiVoucherController@download_attach");
        Route::delete('/delete_multi_voucher_attachment/{id}', "Finance\MultiVoucherController@delete_attach");


        Route::get('/cheque_incoming', "Finance\ChequeIncomingController@index");
        Route::post('/cheque_incoming_status/{id}', "Finance\ChequeIncomingController@changeChequeStatus");

        Route::get('/cheque_outgoing', "Finance\ChequeOutgoingController@index");
        Route::post('/cheque_outgoing_status/{id}', "Finance\ChequeOutgoingController@changeChequeStatus");

        Route::get('/account_statment_anal_report', "Finance\ReportController@account_statment_anal_report_get");
        Route::post('/account_statment_anal_report', "Finance\ReportController@account_statment_anal_report_post");

        Route::post('/trial_balance_report', "Finance\ReportController@trial_balance_report");

        Route::resource('/expense_code', "Finance\ExpenseCodeController");
        Route::post('/expense_code_toggle_active/{id}', "Finance\ExpenseCodeController@toggle_active");

        Route::resource('/tax', "Finance\TaxController");
        Route::post('/tax_toggle_active/{id}', "Finance\TaxController@toggle_active");

        Route::get('/tax_declaration', "Finance\ReportController@tax_declaration_get");
        Route::post('/tax_declaration', "Finance\ReportController@tax_declaration_post");


        // Inventory

        Route::resource('/warehouse', "Inventory\WarehouseController");
        Route::post('/warehouse_toggle_active/{id}', "Inventory\WarehouseController@toggle_active");

        Route::resource('/category', "Inventory\CategoryController");
        Route::get('/get_sub_categorys/{category_id}', "Inventory\CategoryController@get_sub_categorys");
        Route::post('/category_toggle_active/{id}', "Inventory\CategoryController@toggle_active");

        Route::resource('/item_type', "Inventory\ItemTypeController");
        Route::post('/item_type_toggle_active/{id}', "Inventory\ItemTypeController@toggle_active");

        Route::resource('/unit_measurement', "Inventory\UnitMeasurementController");
        Route::post('/unit_measurement_toggle_active/{id}', "Inventory\UnitMeasurementController@toggle_active");

        Route::resource('/item', "Inventory\ItemController");
        Route::get('/get_items_by_category', "Inventory\ItemController@get_items_by_category");
        Route::post('/item_toggle_active/{id}', "Inventory\ItemController@toggle_active");

        Route::resource('/stock_initial_balance', "Inventory\StockInitialBalanceController");
        Route::post('/stock_initial_balance_toggle_active/{id}', "Inventory\StockInitialBalanceController@toggle_active");

        Route::resource('/stock_transaction', "Inventory\StockTransactionController");
        Route::post('/stock_transaction_toggle_active/{id}', "Inventory\StockTransactionController@toggle_active");

        Route::resource('/stock_transfer', "Inventory\StockTransferController");
        Route::post('/stock_transfer_toggle_active/{id}', "Inventory\StockTransferController@toggle_active");
        Route::post('/get_from_warehouse_stock_items', "Inventory\StockTransferController@get_from_warehouse_stock_items");

        Route::resource('/stocktaking', "Inventory\StocktakingController");
        Route::get('/get_stock_items', "Inventory\StocktakingController@get_stock_items");
        Route::post('/stocktaking_toggle_active/{id}', "Inventory\StocktakingController@toggle_active");

        Route::resource('/warehouse_trans', "Inventory\WarehouseTransactionController");
        Route::post('/add_warehouse_trans_attachment', "Inventory\WarehouseTransactionController@add_attachments");
        Route::delete('/delete_warehouse_trans_attachment/{id}', "Inventory\WarehouseTransactionController@delete_attachments");
        Route::post('/warehouse_trans_toggle_active/{id}', "Inventory\WarehouseTransactionController@toggle_active");

        Route::post('/warehouse_tansaction_report', "Inventory\WarehouseTransactionController@warehouse_tansaction_report");

        Route::get('/item_card', "Inventory\ReportController@item_card_get");
        Route::post('/item_card', "Inventory\ReportController@item_card_post");

        Route::get('/warehouse_balance', "Inventory\ReportController@warehouse_balance_get");
        Route::post('/warehouse_balance', "Inventory\ReportController@warehouse_balance_post");

        Route::get('/warehouse_evaluation', "Inventory\ReportController@warehouse_evaluation_get");
        Route::post('/warehouse_evaluation', "Inventory\ReportController@warehouse_evaluation_post");

        Route::get('/item_trial_balance', "Inventory\ReportController@item_trial_balance_get");
        Route::post('/item_trial_balance', "Inventory\ReportController@item_trial_balance_post");

        // Manufacturing
        Route::resource('/work_orders', "Manufacturing\WorkOrderController");
        Route::get('/get_contract/{id}', "Manufacturing\WorkOrderController@get_contract");
        Route::post('/add_work_order_attachment', "Manufacturing\WorkOrderController@add_attachments");
        Route::delete('/delete_work_order_attachment/{id}', "Manufacturing\WorkOrderController@delete_attachments");
        Route::post('/work_orders_toggle_active/{id}', "Manufacturing\WorkOrderController@toggle_active");

        Route::resource('/manufacturing', "Manufacturing\ManufacturingController");
        Route::get('/all_manufacturing_notifications', "Manufacturing\ManufacturingController@all_notifications");

        Route::post('/hold_manufacturing/{id}', "Manufacturing\ManufacturingController@hold_manufacturing");
        Route::post('/end_manufacturing/{id}', "Manufacturing\ManufacturingController@end_manufacturing");
        Route::post('/add_manufacturing_attachment', "Manufacturing\ManufacturingController@add_attachments");
        Route::delete('/delete_manufacturing_attachment/{id}', "Manufacturing\ManufacturingController@delete_attachments");
        Route::post('/manufacturing_toggle_active/{id}', "Manufacturing\ManufacturingController@toggle_active");
        Route::post('/resume_manufacturing/{id}', "Manufacturing\ManufacturingController@resume_manufacturing");

        Route::get('/read_notification/{id}', "Manufacturing\ManufacturingController@read_notification");

        // Sales

        Route::resource('/customer', "Sales\CustomerController");
        Route::post('/customer_sort', "Sales\CustomerController@sort_post");
        Route::get('/customer_info/{id}', "Sales\CustomerController@customer_info");

        Route::post('/customer_toggle_active/{id}', "Sales\CustomerController@toggle_active");
        Route::post('/upload_customer_attachment/{id}', "Sales\CustomerController@upload_customer_attachment");
        Route::get('/download_customer_attachment/{id}', "Sales\CustomerController@download_customer_attachment");
        Route::delete('/delete_customer_attachment/{attachment_id}', "Sales\CustomerController@delete_customer_attachment");
        Route::post('/customer_attachment_toggle_active/{attachment_id}', "Sales\CustomerController@customer_attachment_toggle_active");
        Route::get('/customer_statement_report', "Sales\ReportController@customer_statement_report_get");
        Route::post('/customer_statement_report', "Sales\ReportController@customer_statement_report_post");
        Route::get('/get_customer_debts/{id}', "Sales\CustomerController@get_customer_balance");

        Route::get('/customer_statment', "Sales\ReportController@customer_statment_get");
        Route::post('/customer_statment', "Sales\ReportController@customer_statment_post");
        Route::get('/debt_age_report', "Sales\ReportController@debt_age_report");


        Route::get('/daily_report_get', "Sales\ReportController@daily_report_get");
        Route::post('/daily_report', "Sales\ReportController@daily_report_post");

        Route::post('/full_daily_report', "Sales\ReportController@full_daily_report_post");


        Route::resource('/shift', "Sales\ShiftController");

        Route::resource('/sales_agent', "Sales\SalesAgentController");
        Route::post('/sales_agent_toggle_active/{id}', "Sales\SalesAgentController@toggle_active");

        Route::resource('/customer_type', "Sales\CustomerTypeController");
        Route::post('/customer_type_toggle_active/{id}', "Sales\CustomerTypeController@toggle_active");

        Route::resource('/sales_area', "Sales\SalesAreaController");
        Route::post('/sales_area_toggle_active/{id}', "Sales\SalesAreaController@toggle_active");

        Route::resource('/quotation', "Sales\QuotationController");
        Route::post('/quotation_toggle_active/{id}', "Sales\QuotationController@toggle_active");
        Route::post('/accept_quotation/{id}', "Sales\QuotationController@accept_quotation");
        Route::post('/decline_quotation/{id}', "Sales\QuotationController@decline_quotation");

        Route::resource('/proforma_invoice', "Sales\ProformaInvoiceController");
        Route::post('/proforma_invoice_toggle_active/{id}', "Sales\ProformaInvoiceController@toggle_active");
        Route::post('/proforma_upload_files', "Sales\ProformaInvoiceController@uploadFiles");
        Route::post('/get_customer_quotations', "Sales\ProformaInvoiceController@get_customer_quotations");
        Route::post('/get_quotation_data', "Sales\ProformaInvoiceController@get_quotation_data");

        Route::resource('/delivery_note', "Sales\DeliveryNoteController");
        Route::post('/delivery_note_toggle_active/{id}', "Sales\DeliveryNoteController@toggle_active");
        Route::post('/delivery_note_upload_files', "Sales\DeliveryNoteController@uploadFiles");
        Route::post('/accept_delivery_note', "Sales\DeliveryNoteController@accept_delivery_note");
        Route::post('/update_delivery_note_status/{id}', "Sales\DeliveryNoteController@update_delivery_note_status");
        Route::post('/get_customer_proforma', "Sales\DeliveryNoteController@get_customer_proforma");
        Route::post('/get_proforma_data', "Sales\DeliveryNoteController@get_proforma_data");

        Route::resource('/sales_invoice', "Sales\SalesInvoiceController");
        Route::get('/get_pending_delivery_notes', "Sales\SalesInvoiceController@get_pending_delivery_notes");
        Route::post('/sales_invoice_toggle_active/{id}', "Sales\SalesInvoiceController@toggle_active");
        Route::post('/get_customer_proforma_completed', "Sales\SalesInvoiceController@get_customer_proforma_completed");
        Route::post('/get_delivery_note_data', "Sales\SalesInvoiceController@get_delivery_note_data");





        Route::get('/sales_items_report', "Sales\ReportController@sales_items_report_get");
        Route::post('/sales_items_report', "Sales\ReportController@sales_items_report_post");



        Route::get('/full_report', "Sales\ReportController@full_report_get");
        Route::post('/full_report', "Sales\ReportController@full_report_post");

        Route::get('/sales_report', "Sales\ReportController@sales_report_get");
        Route::post('/sales_report', "Sales\ReportController@sales_report_post");
        Route::get('/sales_weekly_report', "Sales\ReportController@sales_weekly_report");
        Route::get('/sales_monthly_report', "Sales\ReportController@sales_monthly_report");

        Route::get('/customer_balances_report', "Sales\ReportController@customer_balances_report_get");
        Route::post('/customer_balances_report', "Sales\ReportController@customer_balances_report_post");

        Route::get('/proformas_report', "Sales\ReportController@proformas_report_get");
        Route::post('/proformas_report', "Sales\ReportController@proformas_report_post");

        // Purchases

        Route::resource('/purchases_agent', "Purchases\PurchasesAgentController");
        Route::post('/purchases_agent_toggle_active/{id}', "Purchases\PurchasesAgentController@toggle_active");

        Route::resource('/purchases_vendor_type', "Purchases\PurchasesVendorTypeController");
        Route::post('/purchases_vendor_type_toggle_active/{id}', "Purchases\PurchasesVendorTypeController@toggle_active");

        Route::resource('/purchases_vendor', "Purchases\PurchasesVendorController");
        Route::post('/purchases_vendor_toggle_active/{id}', "Purchases\PurchasesVendorController@toggle_active");

        Route::resource('/purchases_order', "Purchases\PurchasesOrderController");
        Route::post('/purchases_order_toggle_active/{id}', "Purchases\PurchasesOrderController@toggle_active");
        Route::post('/purchases_order_upload_files', "Purchases\PurchasesOrderController@uploadFiles");
        Route::post('/accept_purchase_order/{id}', "Purchases\PurchasesOrderController@accept_purchase_order");
        Route::post('/decline_purchase_order/{id}', "Purchases\PurchasesOrderController@decline_purchase_order");

        Route::resource('/purchases_note', "Purchases\PurchasesNoteController");
        Route::post('/purchases_note_toggle_active/{id}', "Purchases\PurchasesNoteController@toggle_active");
        Route::post('/purchases_note_upload_files', "Purchases\PurchasesNoteController@uploadFiles");
        Route::post('/accept_purchases_note/{id}', "Purchases\PurchasesNoteController@accept_purchases_note");
        Route::post('/decline_purchases_note/{id}', "Purchases\PurchasesNoteController@decline_purchases_note");
        Route::post('/get_purchases_order_data', "Purchases\PurchasesNoteController@get_purchases_order_data");
        Route::post('/get_vendor_purchases_order', "Purchases\PurchasesNoteController@get_vendor_purchases_order");

        Route::resource('/purchases_invoice', "Purchases\PurchasesInvoiceController");
        Route::post('/purchases_invoice_toggle_active/{id}', "Purchases\PurchasesInvoiceController@toggle_active");
        Route::post('/purchases_invoice_upload_files', "Purchases\PurchasesInvoiceController@uploadFiles");
        Route::post('/get_purchases_note_data', "Purchases\PurchasesInvoiceController@get_purchases_note_data");

        Route::post('/add_purchase_attach/{id}', "Purchases\PurchasesInvoiceController@add_attach");
        Route::get('/get_purchase_attachs/{id}', "Purchases\PurchasesInvoiceController@get_attachs");
        Route::get('/download_purchase_attach/{id}', "Purchases\PurchasesInvoiceController@download_attach");
        Route::post('/delete_purchase_attachment/{id}', "Purchases\PurchasesInvoiceController@delete_attach");

        Route::resource('/return_purchases', "Purchases\ReturnPurchasesController");
        Route::post('/return_purchases_toggle_active/{id}', "Purchases\ReturnPurchasesController@toggle_active");


       
        Route::get('/purchase_report' , "Purchases\ReportController@purchases_report_get");
        Route::post('/purchase_report' , "Purchases\ReportController@purchases_report_post");
        Route::post('/supplier_balances_report' , "Purchases\ReportController@supplier_balances_report_post");


        Route::get('/purchase_details_report', "Purchases\ReportController@purchases_details_report_get");
        Route::post('/purchase_details_report', "Purchases\ReportController@purchases_details_report_post");

        //suplier statment
        Route::get('/purchase_vendor_statement_report', "Sales\ReportController@purchase_vendor_statement_report_get");
        Route::post('/purchase_vendor_statement_report', "Sales\ReportController@purchase_vendor_statement_report_post");

        // Contracts

        Route::resource('/contract_type', "Contracts\ContractTypeController");
        Route::post('/contract_type_toggle_active/{id}', "Contracts\ContractTypeController@toggle_active");


        Route::resource('/contract', "Contracts\ContractController");
        Route::get('/contract_d', "Contracts\ContractController@all_contract_d");
        Route::get('/installments_due', "Contracts\ContractController@all_installments_due");
        Route::get('/create_contract_invoice', "Contracts\ContractController@create_contract_invoice_get");
        Route::post('/create_contract_invoice', "Contracts\ContractController@create_contract_invoice_post");
        Route::post('/installments_delay/{id}', "Contracts\ContractController@installments_delay_transaction");
        Route::put('/contract_activation/{id}', "Contracts\ContractController@contract_activation");


        // Barbers

        Route::resource('/barber_shop_time', "Barbers\BarberShopTimeController");

        Route::resource('/barber', "Barbers\BarberController");
        Route::post('/barber_toggle_active/{id}', "Barbers\BarberController@toggle_active");

        Route::resource('/barber_vacation', "Barbers\BarberVacationController");
        Route::post('/barber_vacation_toggle_active/{id}', "Barbers\BarberVacationController@toggle_active");

        Route::resource('/barber_customer', "Barbers\BarberCustomerController");

        Route::resource('/barber_booking', "Barbers\BarberBookingController");
        Route::post('/check_booking_services_blocks', "Barbers\BarberBookingController@check_booking_services_blocks");
        Route::post('/cancel_barber_booking/{id}', "Barbers\BarberBookingController@cancel_barber_booking");

        //Assets

        Route::resource('/assets_settings', "Assets\AssetsSettingsController");

        Route::resource('/assets_category', "Assets\AssetsCategoriesController");
        Route::post('/assets_category_toggle_active/{id}', "Assets\AssetsCategoriesController@toggle_active");

        Route::resource('/assets', "Assets\AssetsController");
        Route::post('/add_asset_attachments', "Assets\AssetsController@add_attachments");
        Route::delete('/delete_asset_attachments/{id}', "Assets\AssetsController@delete_attachments");
        Route::post('/assets_toggle_active/{id}', "Assets\AssetsController@toggle_active");

        Route::resource('/assets_selling', "Assets\AssetsSellingController");
        Route::post('/add_asset_selling_attachments', "Assets\AssetsSellingController@add_attachments");
        Route::delete('/delete_assets_selling_attachment/{id}', "Assets\AssetsSellingController@delete_attachments");

        Route::resource('/assets_develop', "Assets\AssetsDevelopController");
        Route::post('/add_asset_develop_attachments', "Assets\AssetsDevelopController@add_attachments");
        Route::delete('/delete_assets_develop_attachment/{id}', "Assets\AssetsDevelopController@delete_attachments");

        Route::resource('/assets_deprecating', "Assets\AssetsDeprecatingController");

        Route::resource('/calculate_deprecating', "Assets\DepreciationCalculateController");
        Route::post('/get_calculation', "Assets\DepreciationCalculateController@get_calculation");

        // financial statements

        Route::resource('/financial_statements', "FinancialStatements\FinancialStatementsController");
        Route::post('/statement_toggle_active', "FinancialStatements\FinancialStatementsController@toggle_active");

        Route::resource('/financial_collections', "FinancialStatements\FinancialCollectionsController");

        Route::get('/statement_report', "FinancialStatements\FinancialStatementsController@get_report");

        // elevators

        Route::resource('/elevators_models', "Elevators\ElevatorModelsController");
        Route::post('/elevators_models_toggle_active/{id}', "Elevators\ElevatorModelsController@toggle_active");
        Route::get('/get_model_lookup/{id}', "Elevators\ElevatorModelsController@model_lookup");


        Route::resource('/elevators_types', "Elevators\ElevatorTypesController");
        Route::post('/elevators_types_toggle_active/{id}', "Elevators\ElevatorTypesController@toggle_active");

        Route::resource('/elevators_payments', "Elevators\ElevatorPaymentsController");
        Route::post('/elevators_payments_toggle_active/{id}', "Elevators\ElevatorPaymentsController@toggle_active");


        Route::resource('/elevators_quotation', "Elevators\ElevatorsQuotationController");
        Route::post('/elevators_quotation_admin_response/{id}', "Elevators\ElevatorsQuotationController@administrator_response");
        Route::post('/elevators_convert_contract/{id}', "Elevators\ElevatorsQuotationController@convert_contract");

        Route::post('/add_quotation_attachments/{id}', "Elevators\ElevatorsQuotationController@add_attachments");
        Route::delete('/delete_quotation_attachments/{id}', "Elevators\ElevatorsQuotationController@delete_attachments");
        Route::post('/elevators_quotation_toggle_active/{id}', "Elevators\ElevatorsQuotationController@toggle_active");
        Route::get('/get_all_quotation_payment', "Elevators\ElevatorsQuotationController@get_all_payments");
        Route::post('/start_payment_stage/{id}', "Elevators\ElevatorsQuotationController@start_payment_stage");
        Route::post('/end_payment_stage/{id}', "Elevators\ElevatorsQuotationController@end_payment_stage");
        Route::post('/payment_installment/{id}', "Elevators\ElevatorsQuotationController@payment_installment");

        // POS

        Route::group(["namespace" => "POS"], function () {
            Route::post('/add_customer', "GeneralController@add_customer");
            Route::post('/start_shift', "GeneralController@start_shift");
            Route::post('/end_shift', "GeneralController@end_shift");
            Route::get('/get_home_data', "GeneralController@get_home_data");
            Route::get('/search_customer', "GeneralController@search_customer");

            Route::get('/get_sales_invoices', "SalesInvoiceController@get_sales_invoices");
            Route::get('/get_sales_invoice/{id}', "SalesInvoiceController@get_sales_invoice");
            Route::get('/search_item', "SalesInvoiceController@search_item");
            Route::get('/create_sales_invoice', "SalesInvoiceController@create_sales_invoice");
            Route::post('/add_sales_invoice', "SalesInvoiceController@add_sales_invoice");

            Route::get('/get_sales_orders', "SalesOrderController@get_sales_orders");
            Route::get('/get_sales_order/{id}', "SalesOrderController@get_sales_order");
            Route::post('/add_sales_order', "SalesOrderController@add_sales_order");
            Route::post('/delete_sales_order/{id}', "SalesOrderController@delete_sales_order");

            Route::get('/get_notice_debtors', "NoticeDebtorController@get_notice_debtors");
            Route::get('/get_notice_debtor/{id}', "NoticeDebtorController@get_notice_debtor");
            Route::get('/create_notice_debtor', "NoticeDebtorController@create_notice_debtor");
            Route::post('/add_notice_debtor', "NoticeDebtorController@add_notice_debtor");

            Route::get('/get_notice_creditors', "NoticeCreditorController@get_notice_creditors");
            Route::get('/get_notice_creditor/{id}', "NoticeCreditorController@get_notice_creditor");
            Route::get('/create_notice_creditor', "NoticeCreditorController@create_notice_creditor");
            Route::post('/add_notice_creditor', "NoticeCreditorController@add_notice_creditor");

            Route::post('/generate_pos_report', "ReportController@generate_pos_report");

            Route::resource('/coupons', "CouponController");
            Route::get('/check_coupon', "CouponController@check_code");
            Route::get('/get_coupon_data/{coupon_code}', "CouponController@get_coupon_data");
            Route::post('/coupons_toggle_active/{id}', "CouponController@toggle_active");
            Route::get('/get_creat_report', "BookingReportController@get_create_report");
            Route::post('/platform_report', "BookingReportController@get_platform_report");
            Route::post('/coupon_report', "BookingReportController@get_coupon_report");

            //            Route::get('/full_report' , "ReportController@full_report_get");
            //            Route::post('/full_report' , "ReportController@full_report_post");
            //
            //            Route::get('/sales_report' , "ReportController@sales_report_get");
            //            Route::post('/sales_report' , "ReportController@sales_report_post");

            Route::resource('/expense', "ExpenseController");

            Route::get('/get_barber_bookings', "BarberBookingController@get_barber_bookings");
            Route::get('/get_barber_booking/{id}', "BarberBookingController@get_barber_booking");

            Route::post('/nfc_payment', "NearpayController@nfc_payment");
            Route::get('/get_allowed_payment_devices', "NearpayController@get_allowed_payment_devices");
            Route::post('/nfc_payment_callback', "NearpayController@nfc_payment_callback");
        });
    });
});
Route::group(['prefix' => 'website/{lang}', 'where' => ['lang' => 'en|ar'], "namespace" => "App\Http\Controllers\API\Website"], function () {

    // Frontend

    Route::post('/login_mobile', "Frontend\AuthController@login_mobile");
    Route::post('/login_otp', "Frontend\AuthController@login_otp");
    Route::post('/login_social', "Frontend\AuthController@login_social");

    Route::get('/get_home', "Frontend\HomePageController@get_home_data");
    Route::get('/get_coupon_data/{coupon_code}', "Frontend\Booking\BookingsController@get_coupon_data");
    Route::post('/get_available_times', "Frontend\Booking\BookingsController@get_available_times");
    Route::post('/get_available_dates', "Frontend\Booking\BookingsController@get_available_dates");
    Route::get('/create_booking', "Frontend\Booking\BookingsController@create_booking");

    Route::group(['middleware' => 'auth:customer'], function () {
        Route::get('/get_my_profile', "Frontend\GeneralController@get_my_profile");
        Route::post('/update_profile', "Frontend\GeneralController@update_profile");

        Route::post('/make_booking', "Frontend\Booking\BookingsController@make_booking");
        Route::post('/claim_gift', "Frontend\Booking\BookingsController@claim_gift");
        Route::post('/update_booking/{id}', "Frontend\Booking\BookingsController@update_booking");
        Route::post('/reject_booking/{id}', "Frontend\Booking\BookingsController@reject_booking");
        Route::get('/get_my_bookings', "Frontend\Booking\BookingsController@get_my_bookings");
        Route::get('/get_booking_details/{id}', "Frontend\Booking\BookingsController@get_booking_details");
        Route::get('/get_customer_wallet_points', "Frontend\Booking\BookingsController@get_customer_wallet_points");
    });
});
