<?php

use Illuminate\Support\Facades\Rodddute;
use Illuminate\Support\Facades\Route;

Route::group(['prefix'=>'v1/{lang}' ,'middleware' => ['VerifyAPIBookingAccess'] , 'where' => ['lang' => 'en|ar']  , "namespace"=>"App\Http\Controllers\API\EX\V1"  ], function(){


    Route::get('/get_coupon_data/{coupon_code}', "BookingController@get_coupon_data");
    Route::post('/get_available_times', "BookingController@get_available_times");

    Route::get('/create_booking', "BookingController@create_booking");
    Route::post('/make_booking', "BookingController@make_booking");

    Route::get('/get_my_bookings', "BookingController@get_my_bookings");
    Route::get('/get_booking_details/{id}', "BookingController@get_booking_details");
    Route::get('/all_bookings', "BookingController@index");
    Route::get('/search_customer','BookingController@search_customer');

    Route::group(['middleware' => 'auth:api'], function(){
        Route::get('/barber_bookings', "BookingController@barbers_bookings");
        Route::post('/order_start/{id}', "BookingController@barbers_start_order");
        Route::post('/order_end/{id}', "BookingController@barbers_end_order");

    });
});

?>
